/*
 * Decompiled with CFR 0.152.
 */
package joana.sdg;

import joana.sdg.SDGNode;

public class SDGEdge
implements Cloneable {
    private static final long serialVersionUID = 2L;
    Kind kind;
    private String label;
    private SDGNode source;
    private SDGNode target;

    SDGEdge(SDGNode source, SDGNode target) {
        this.source = source;
        this.target = target;
    }

    public SDGEdge(SDGNode source, SDGNode sink, Kind kind) {
        this(source, sink);
        this.kind = kind;
    }

    public SDGEdge(SDGNode source, SDGNode sink, Kind kind, String label) {
        this(source, sink, kind);
        this.label = label;
    }

    public SDGNode getSource() {
        return this.source;
    }

    public SDGNode getTarget() {
        return this.target;
    }

    public Kind getKind() {
        return this.kind;
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String arg0) {
    }

    public boolean isParameter() {
        return this.getKind() == Kind.PARAMETER_IN || this.getKind() == Kind.PARAMETER_OUT;
    }

    public boolean isDataDependence() {
        return this.getKind() == Kind.DATA_DEP;
    }

    public boolean isDataDepOrParam() {
        return this.isDataDependence() || this.isParameter();
    }

    public String toString() {
        return this.label;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof SDGEdge) {
            SDGEdge edge = (SDGEdge)o2;
            if (this.label == null && edge.getLabel() != null) {
                return false;
            }
            if (this.label != null && edge.getLabel() == null) {
                return false;
            }
            if (!this.getSource().equals(edge.getSource())) {
                return false;
            }
            if (!this.getTarget().equals(edge.getTarget())) {
                return false;
            }
            return this.getKind().equals((Object)edge.getKind());
        }
        return false;
    }

    public int hashCode() {
        return (this.getSource().hashCode() + this.getTarget().hashCode() + this.kind.hashCode()) % Integer.MAX_VALUE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        HELP("HE", false),
        CONTROL_FLOW("CF", false),
        NO_FLOW("NF", false),
        JUMP_FLOW("JF", false),
        RETURN("RF", false),
        CONTROL_DEP_UNCOND("UN", true),
        CONTROL_DEP_COND("CD", true),
        CONTROL_DEP_EXPR("CE", true),
        CONTROL_DEP_CALL("CC", true),
        JUMP_DEP("JD", true),
        DATA_DEP("DD", true),
        DATA_LOOP("DL", true),
        DATA_DEP_EXPR_VALUE("VD", true),
        DATA_DEP_EXPR_REFERENCE("RD", true),
        SUMMARY("SU", true),
        SUMMARY_P("SP", true),
        CALL("CL", true),
        PARAMETER_IN("PI", true),
        PARAMETER_OUT("PO", true),
        INTERFERENCE("ID", true),
        INTERFERENCE_WRITE("IW", false),
        FOLDED("FD", true),
        FOLD_INCLUDE("FI", false),
        FORK("FORK", true),
        FORK_IN("FORK_IN", true),
        FORK_OUT("FORK_OUT", true),
        JOIN("JOIN", true);

        private final String value;
        private final boolean isSDG;

        private Kind(String s2, boolean sdg) {
            this.value = s2;
            this.isSDG = sdg;
        }

        public String toString() {
            return this.value;
        }

        public boolean isSDGEdge() {
            return this.isSDG;
        }

        public boolean isIntraSDGEdge() {
            return this == CONTROL_DEP_UNCOND || this == CONTROL_DEP_COND || this == CONTROL_DEP_EXPR || this == CONTROL_DEP_CALL || this == JUMP_DEP || this == DATA_DEP || this == DATA_LOOP || this == DATA_DEP_EXPR_VALUE || this == DATA_DEP_EXPR_REFERENCE || this == SUMMARY || this == SUMMARY_P;
        }

        public static Kind[] controlFlowEdges() {
            Kind[] cf = new Kind[]{CONTROL_FLOW, NO_FLOW, JUMP_FLOW, RETURN, CALL, FORK};
            return cf;
        }

        public static Kind[] dataflowEdges() {
            Kind[] df = new Kind[]{CONTROL_DEP_UNCOND, CONTROL_DEP_COND, CONTROL_DEP_EXPR, CONTROL_DEP_CALL, JUMP_DEP, DATA_DEP, DATA_LOOP, DATA_DEP_EXPR_VALUE, DATA_DEP_EXPR_REFERENCE, SUMMARY, SUMMARY_P, CALL, PARAMETER_IN, PARAMETER_OUT, INTERFERENCE, FORK, FORK_IN, FORK_OUT};
            return df;
        }
    }
}

