/*
 * Decompiled with CFR 0.152.
 */
package joana.sdg;

import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDGNode {
    private static final IDComparator idcomp = new IDComparator();
    private int id;
    private String source;
    private int proc;
    private Operation operation;
    private String value;
    private String type;
    private int sr;
    private int sc;
    private int er;
    private int ec;
    private Kind kind;
    private int[] threadNumbers;

    protected SDGNode(int id, Operation op, String value, int proc, String type, String source, int sr, int sc, int er, int ec) {
        this.kind = op.kind[0];
        this.id = id;
        this.operation = op;
        this.value = value;
        this.source = source;
        this.sr = sr;
        this.sc = sc;
        this.er = er;
        this.ec = ec;
        this.proc = proc;
        this.type = type;
    }

    protected SDGNode(Kind kind, int id, Operation op, String value, int proc, String type, String source, int sr, int sc, int er, int ec) {
        this(id, op, value, proc, type, source, sr, sc, er, ec);
        assert (op.kind[1] == kind);
        this.kind = kind;
    }

    public SDGNode(Kind kind, int id, int proc) {
        this.kind = kind;
        this.operation = Operation.EMPTY;
        this.id = id;
        this.proc = proc;
        this.sr = -1;
        this.sc = -1;
        this.er = -1;
        this.ec = -1;
    }

    public SDGNode clone() {
        return new SDGNode(this.kind, this.id, this.operation, this.value, this.proc, this.type, this.source, this.sr, this.sc, this.er, this.ec);
    }

    public void setThreadNumbers(int[] tn) {
        this.threadNumbers = tn;
    }

    public int[] getThreadNumbers() {
        return this.threadNumbers;
    }

    public boolean isParameter() {
        return this.getKind() == Kind.FORMAL_IN || this.getKind() == Kind.FORMAL_OUT || this.getKind() == Kind.ACTUAL_IN || this.getKind() == Kind.ACTUAL_OUT || this.getKind() == Kind.EXIT;
    }

    public boolean hasLabel() {
        return true;
    }

    public String getLabel() {
        return this.value;
    }

    public void setLabel(String arg0) {
        this.value = arg0;
    }

    public int getEr() {
        return this.er;
    }

    public int getEc() {
        return this.ec;
    }

    public void setId(int i2) {
        this.id = i2;
    }

    public int getId() {
        return this.id;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public int getProc() {
        return this.proc;
    }

    public void setProc(int p2) {
        this.proc = p2;
    }

    public int getSc() {
        return this.sc;
    }

    public String getSource() {
        return this.source;
    }

    public int getSr() {
        return this.sr;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public boolean equals(Object o2) {
        if (o2 instanceof SDGNode) {
            SDGNode node = (SDGNode)o2;
            if (this.id != node.getId()) {
                return false;
            }
            if (!this.operation.equals((Object)node.getOperation())) {
                return false;
            }
            if (this.value != null && !this.value.equals(node.getLabel())) {
                return false;
            }
            if (this.value == null && node.getLabel() != null) {
                return false;
            }
            if (this.sr != node.getSr()) {
                return false;
            }
            if (this.sc != node.getSc()) {
                return false;
            }
            if (this.er != node.getEr()) {
                return false;
            }
            if (this.ec != node.getEc()) {
                return false;
            }
            if (this.proc != node.getProc()) {
                return false;
            }
            if (this.type != null && !this.type.equals(node.getType())) {
                return false;
            }
            if (this.type == null && node.getType() != null) {
                return false;
            }
            if (this.source != null && !this.source.equals(node.getSource())) {
                return false;
            }
            return this.source != null || node.getSource() == null;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public static Comparator<SDGNode> getIDComparator() {
        return idcomp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IDComparator
    implements Comparator<SDGNode> {
        private IDComparator() {
        }

        @Override
        public int compare(SDGNode n1, SDGNode n2) {
            return n1.getId() - n2.getId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        EMPTY("empty", Kind.EXPRESSION, Kind.FOLDED),
        INT_CONST("intconst", Kind.EXPRESSION, Kind.PREDICATE, Kind.ACTUAL_IN),
        FLOAT_CONST("floatconst", Kind.EXPRESSION),
        CHAR_CONST("charconst", Kind.EXPRESSION),
        STRING_CONST("stringconst", Kind.EXPRESSION),
        FUNCTION_CONST("functionconst", Kind.EXPRESSION),
        SHORTCUT("shortcut", Kind.EXPRESSION, Kind.PREDICATE, Kind.ACTUAL_IN),
        QUESTION("question", Kind.EXPRESSION),
        BINARY("binary", Kind.EXPRESSION, Kind.PREDICATE),
        UNARY("unary", Kind.EXPRESSION),
        DEREFER("derefer", Kind.EXPRESSION, Kind.PREDICATE, Kind.ACTUAL_IN),
        REFER("refer", Kind.EXPRESSION, Kind.PREDICATE, Kind.ACTUAL_IN),
        ARRAY("array", Kind.EXPRESSION),
        SELECT("select", Kind.EXPRESSION),
        REFERENCE("reference", Kind.EXPRESSION, Kind.PREDICATE, Kind.ACTUAL_IN),
        DECLARATION("declaration", Kind.NORMAL),
        MODIFY("modify", Kind.EXPRESSION, Kind.PREDICATE),
        MODASSIGN("modassign", Kind.EXPRESSION),
        ASSIGN("assign", Kind.EXPRESSION),
        IF("IF", Kind.PREDICATE, Kind.NORMAL),
        LOOP("loop", Kind.NORMAL),
        JUMP("jump", Kind.NORMAL),
        COMPOUND("compound", Kind.NORMAL),
        CALL("call", Kind.CALL),
        ENTRY("entry", Kind.ENTRY),
        EXIT("exit", Kind.EXIT),
        FORMAL_IN("form-in", Kind.FORMAL_IN),
        FORMAL_ELLIP("form-ellip", Kind.FORMAL_IN),
        FORMAL_OUT("form-out", Kind.FORMAL_OUT),
        ACTUAL_IN("act-in", Kind.ACTUAL_IN),
        ACTUAL_OUT("act-out", Kind.ACTUAL_OUT),
        MONITOR("monitor", Kind.SYNCHRONIZATION),
        SUMMARY("summary", Kind.SUMMARY);

        private final String value;
        private final Kind[] kind;

        private Operation(String s2, Kind k2) {
            this.value = s2;
            this.kind = new Kind[]{k2};
        }

        private Operation(String s2, Kind k1, Kind k2) {
            this.value = s2;
            this.kind = new Kind[]{k1, k2};
        }

        private Operation(String s2, Kind k1, Kind k2, Kind k3) {
            this.value = s2;
            this.kind = new Kind[]{k1, k2, k3};
        }

        public String toString() {
            return this.value;
        }

        Kind[] getCorrespondingKind() {
            return this.kind;
        }

        public SDGNode createNode(int id, String value, int proc, String type, String source, int sr, int sc, int er, int ec) {
            return new SDGNode(id, this, value, proc, type, source, sr, sc, er, ec);
        }

        public SDGNode createNode(int kind, int id, String value, int proc, String type, String source, int sr, int sc, int er, int ec) {
            return new SDGNode(this.kind[kind], id, this, value, proc, type, source, sr, sc, er, ec);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        NORMAL("NORM"),
        EXPRESSION("EXPR"),
        PREDICATE("PRED"),
        CALL("CALL"),
        ACTUAL_IN("ACTI"),
        ACTUAL_OUT("ACTO"),
        ENTRY("ENTR"),
        EXIT("EXIT"),
        FORMAL_IN("FRMI"),
        FORMAL_OUT("FRMO"),
        SYNCHRONIZATION("SYNC"),
        FOLDED("FOLD"),
        JOIN("JOIN"),
        SUMMARY("Summary");

        private final String value;

        private Kind(String s2) {
            this.value = s2;
        }

        public String toString() {
            return this.value;
        }
    }
}

