#! /bin/bash
if [ $# == 0 ]; then
  echo "Usage: $0 <validated-grs-script>"
  exit 1
fi

if [[ "$(uname -s)" == "Linux" ]]; then
  exeprefix=mono
fi

for scriptfile in $*; do
  if [ ! -f "$scriptfile" ]; then
    echo "$scriptfile is not a file!"
    exit 1
  fi

  if [[ "$scriptfile" != *\.grs ]]; then
    echo "$scriptfile is not a .grs file!"
    exit 1
  fi

  echo "$scriptfile"

  $exeprefix ../bin/GrShell.exe "$scriptfile" 2>&1 | awk "{sub(\"\\r\$\", \"\")}
    /^All attributes/ {
      print \$5
      print \$8
      getline
      while(\$0 ~ /^ - /) {
        print getAttribute(4)
        getline
      }
    }
    /(^The available attributes for)|(^(Node|Edge|Object|Transient object|node|edge|object|transient object) types)|(^(Sub|Super) types of (Node|Edge|Object|Transient object|node|edge|object|transient object) type)/ {
      getline
      while(\$0 ~ /^ - /) {
        print \$0
        getline
      }
    }
    /matches found/ { print \$2 }
    /rewrites performed/ { print \$2 }
    /Number/ { print \$8 }
    /value of attribute/ { print getAttribute(7) }
    /value of variable/ { print getAttribute(10) }
    /The graph is/ { print \$4 }
    /reported back:/ { print \"warning reported back\" }
    /Evaluating Sequence Expression done/ { print getAttribute(10) }
    /Executing Graph Rewrite Sequence done/ { print getAttribute(11) }

    function getAttribute(startindex)
    {
      if(startindex > NF) return \"\"

      value = \$startindex
      for(i = startindex + 1; i <= NF; i++)
      {
        value = value \" \" \$i
      }
      sub(\"\\r\",\"\",value)
      return value
    }" > "$scriptfile".data && echo "Data file generated" || echo "Data file generation failed!"
done
